package com.moloco.sdk.internal.publisher.nativead.ui

import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.Font
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.unit.TextUnit
import androidx.compose.ui.unit.sp
import com.moloco.sdk.R
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeAssetOnClick

@Composable
internal fun NativeAdText(
    modifier: Modifier = Modifier,
    text: String,
    color: Color = Color.Unspecified,
    maxLines: Int = 1,
    fontWeight: FontWeight? = null,
    fontSize: TextUnit = TextUnit.Unspecified,
    onClick: NativeAssetOnClick
) {
    Text(
        modifier = modifier.clickable(onClick),
        text = text,
        color = color,
        maxLines = maxLines,
        fontWeight = fontWeight,
        fontSize = fontSize,
        fontFamily = NativeAdTextFont,
        letterSpacing = 0.sp,
        overflow = TextOverflow.Ellipsis
    )
}

private val NativeAdTextFont = FontFamily(
    Font(R.font.inter_regular)
)
