package com.moloco.sdk.internal.publisher.nativead.ui

import androidx.compose.animation.Crossfade
import androidx.compose.foundation.layout.padding
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.moloco.sdk.R
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.GenericIconButton
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.DefaultPlaybackControlUI

internal val NativeVideoPlaybackControlUI: DefaultPlaybackControlUI = { isPlaying, onClick ->
    Crossfade(
        modifier = Modifier
            .align(Alignment.BottomCenter)
            .padding(4.dp),
        targetState = isPlaying
    ) {
        val painterResource = painterResource(
            id = if (it) R.drawable.moloco_twotone_pause_24 else R.drawable.moloco_twotone_play_arrow_24
        )

        GenericIconButton(
            painter = painterResource,
            onClick = onClick,
            contentDescription = "play/pause",
            tint = Color.White
        )
    }
}
