package com.moloco.sdk.internal.publisher.nativead.ui

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.requiredSize
import androidx.compose.material.Icon
import androidx.compose.material.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.moloco.sdk.R

@Composable
internal fun Privacy(modifier: Modifier = Modifier, onClick: () -> Unit) {
    Icon(
        modifier = modifier
            .requiredSize(20.dp)
            .clickable(onClick),
        painter = painterResource(id = R.drawable.moloco_privacy),
        tint = Color.Unspecified,
        contentDescription = "privacy"
    )
}

@Preview(showBackground = true)
@Composable
private fun PrivacyPreview() {
    MaterialTheme {
        Box(modifier = Modifier.background(Color.White)) {
            Privacy(onClick = {
            })
        }
    }
}
