package com.moloco.sdk.internal.publisher.nativead.ui

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.width
import androidx.compose.material.Icon
import androidx.compose.material.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.moloco.sdk.R
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeAssetOnClick

// small - for small native ad template
// medium - for medium native ad template
// https://www.figma.com/file/lIwzPugngoeKs387EbbC5m/Native-Ads?type=design&node-id=0-1&mode=design&t=E4KnEhnieHCUxvGd-0

@Composable
internal fun RatingSmall(
    modifier: Modifier = Modifier,
    stars: Int,
    outOf: Int,
    onClick: NativeAssetOnClick
) {
    Rating(
        modifier.height(15.dp),
        stars,
        outOf,
        onClick
    )
}

@Composable
internal fun RatingMedium(
    modifier: Modifier = Modifier,
    stars: Int,
    outOf: Int,
    onClick: NativeAssetOnClick
) {
    Rating(
        modifier.height(12.dp),
        stars,
        outOf,
        onClick
    )
}

@Composable
private fun Rating(
    modifier: Modifier = Modifier,
    stars: Int,
    outOf: Int,
    onClick: NativeAssetOnClick
) {
    Row(
        modifier = modifier.clickable(onClick)
    ) {
        for (i in 1..outOf) {
            Star(fill = i <= stars)
            if (i != outOf) {
                Spacer(Modifier.width(1.dp))
            }
        }
    }
}

@Composable
private fun Star(modifier: Modifier = Modifier, fill: Boolean) {
    Icon(
        modifier = modifier,
        painter = painterResource(id = R.drawable.moloco_star),
        tint = if (fill) StarFillColor else StarNonFillColor,
        contentDescription = "rating star"
    )
}

private val StarFillColor: Color = Color(0xFFFFC700)
private val StarNonFillColor: Color = Color(0xFFD9D9D9)

@Preview(showBackground = true)
@Composable
private fun StarPreview() {
    MaterialTheme {
        Column {
            RatingSmall(stars = 3, outOf = 5) { }
            SpacerS()

            RatingMedium(stars = 6, outOf = 4, onClick = null)
            SpacerS()

            Rating(stars = -1, outOf = 6) {}
            SpacerS()
        }
    }
}

@Composable
private fun SpacerS() {
    Spacer(modifier = Modifier.height(80.dp))
}
