package com.moloco.sdk.internal.publisher.nativead.ui.templates

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.foundation.layout.IntrinsicSize
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.moloco.sdk.internal.publisher.nativead.ui.Privacy
import com.moloco.sdk.internal.publisher.nativead.ui.SponsorLabel
import com.moloco.sdk.internal.publisher.nativead.ui.clickable

@Composable
internal fun NativeContainer(
    modifier: Modifier = Modifier,
    showSponsoredLabel: Boolean,
    privacyOnClick: NativeAssetOnClick,
    containerOnClick: NativeAssetOnClick,
    content: @Composable ColumnScope.(hasHeader: Boolean) -> Unit
) {
    Column(
        modifier = modifier
            .background(NativeBannerBackground)
            .clickable(containerOnClick)
            .width(IntrinsicSize.Max),
        verticalArrangement = Arrangement.Center
    ) {
        val hasHeader = showSponsoredLabel || privacyOnClick != null

        if (hasHeader) {
            Row(
                modifier = Modifier.height(20.dp)
            ) {
                if (showSponsoredLabel) {
                    SponsorLabel(
                        modifier = Modifier.padding(top = 1.dp, start = 1.dp)
                    )
                }

                if (privacyOnClick != null) {
                    Spacer(modifier = Modifier.weight(1.0f))
                    Privacy(onClick = privacyOnClick)
                }
            }
        }

        content(hasHeader)
    }
}

private val NativeBannerBackground = Color.White

@Composable
@Preview(showBackground = true)
private fun NativeContainerPreview() {
    MaterialTheme {
        NativeContainer(
            showSponsoredLabel = true,
            privacyOnClick = { },
            containerOnClick = { }
        ) {
            Text("adfd as aass asdsa dasd asasd a ds asd s")
            Text("adfd ")
        }
    }
}
