package com.moloco.sdk.internal.publisher.nativead.ui.templates

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.moloco.sdk.internal.publisher.nativead.ui.CTAMedium
import com.moloco.sdk.internal.publisher.nativead.ui.IconImageMedium
import com.moloco.sdk.internal.publisher.nativead.ui.RatingMedium
import com.moloco.sdk.internal.publisher.nativead.ui.SponsorTextMedium
import com.moloco.sdk.internal.publisher.nativead.ui.TitleMedium

@Composable
internal fun NativeMedium(
    modifier: Modifier = Modifier,
    data: NativeTemplateBaseData,
    content: @Composable ColumnScope.() -> Unit
) {
    NativeContainer(
        modifier = modifier,
        showSponsoredLabel = data.sponsored != null,
        privacyOnClick = data.privacyOnClick,
        containerOnClick = data.mainLinkOnClick
    ) { hasHeader ->

        Row(
            modifier = Modifier.padding(
                start = NativeMediumContentHorizontalPadding,
                end = NativeMediumContentHorizontalPadding,
                top = if (hasHeader) 0.dp else 16.dp
            ),
            verticalAlignment = Alignment.CenterVertically
        ) {
            val icon = data.icon
            IconImageMedium(
                imageUri = icon.uri,
                onClick = icon.onClick
            )

            Column(modifier = Modifier.padding(start = 8.dp)) {
                val title = data.title
                TitleMedium(text = title.text, onClick = title.onClick)

                val sponsored = data.sponsored
                if (sponsored != null) {
                    SponsorTextMedium(text = sponsored.text, onClick = sponsored.onClick)
                }

                val rating = data.rating
                if (rating != null) {
                    RatingMedium(
                        stars = rating.stars.toInt(),
                        outOf = rating.outOf,
                        onClick = rating.onClick
                    )
                }
            }
        }

        content()

        val cta = data.cta
        CTAMedium(text = cta.text, onClick = cta.onClick)
    }
}

internal val NativeMediumContentHorizontalPadding = 19.dp

@Composable
@Preview(showBackground = true)
private fun NativeMediumPreview() {
    MaterialTheme {
        NativeMedium(
            modifier = Modifier.size(300.dp, 250.dp),
            data = NativeTemplateBaseData(
                icon = NativeTemplateBaseData.Image(
                    uri = "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTJGMIttEjf8B1rP9xaWUviUNJBuGjpTCc-7GpRW5Ue&s",
                    onClick = { }
                ),
                title = NativeTemplateBaseData.TextField(
                    text = "Bubble Pop! Puzzle Game Legend",
                    onClick = { }
                ),
                sponsored = NativeTemplateBaseData.TextField(
                    text = "Bitmango",
                    onClick = { }
                ),
                rating = NativeTemplateBaseData.Rating(4F, 5, onClick = { }),
                cta = NativeTemplateBaseData.CTA(
                    text = "Download Now",
                    onClick = { }
                ),
                privacyOnClick = { },
                mainLinkOnClick = { }
            )
        ) {
            Text(text = "content")
        }
    }
}
