package com.moloco.sdk.internal.publisher.nativead.ui.templates

import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import coil.compose.AsyncImage
import com.moloco.sdk.internal.publisher.nativead.ui.clickable

@Composable
internal fun NativeMediumImage(modifier: Modifier = Modifier, data: NativeMediumImageData) {
    NativeMedium(modifier = modifier, data = data) {
        val mainImage = data.mainImage
        AsyncImage(
            modifier = Modifier
                .padding(NativeMediumContentHorizontalPadding, vertical = 11.dp)
                .weight(1.0f)
                .fillMaxWidth()
                .clickable(mainImage.onClick),
            model = mainImage.uri,
            contentScale = ContentScale.Fit,
            contentDescription = "main image"
        )
    }
}

@Composable
@Preview(showBackground = true)
private fun NativeMediumImagePreview() {
    MaterialTheme {
        NativeMediumImage(
            modifier = Modifier.size(300.dp, 250.dp),
            data = NativeMediumImageData(
                mainImage = NativeTemplateBaseData.Image(
                    uri = "https://cdn.pixabay.com/photo/2018/04/22/12/27/butterfly-3340921_1280.png",
                    onClick = { }
                ),
                icon = NativeTemplateBaseData.Image(
                    uri = "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTJGMIttEjf8B1rP9xaWUviUNJBuGjpTCc-7GpRW5Ue&s",
                    onClick = { }
                ),
                title = NativeTemplateBaseData.TextField(
                    text = "Bubble Pop! Puzzle Game Legend",
                    onClick = { }
                ),
                sponsored = NativeTemplateBaseData.TextField(
                    text = "Bitmango",
                    onClick = { }
                ),
                rating = NativeTemplateBaseData.Rating(4F, 5, onClick = { }),
                cta = NativeTemplateBaseData.CTA(
                    text = "Download Now",
                    onClick = { }
                ),
                privacyOnClick = { },
                mainLinkOnClick = { }
            )
        )
    }
}
