package com.moloco.sdk.internal.publisher.nativead.ui.templates

import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.moloco.sdk.internal.publisher.nativead.ui.clickable
import com.moloco.sdk.service_locator.SdkObjectFactory
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.VastAdShowError
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.GoNextAction
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.PlaybackProgress
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.PreparedVastResource
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ValueWrapper
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.AdViewModel
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.OverrideVastContainerOnClick
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.VastRenderer
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.linear.LinearViewModel
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow

@Composable
internal fun NativeMediumVideo(
    modifier: Modifier = Modifier,
    data: NativeMediumVideoData,
    viewVisibilityTracker: ViewVisibilityTracker,
) {
    NativeMedium(modifier = modifier, data = data) {
        val video = data.video

        VastRenderer(
            modifier = Modifier
                .padding(NativeMediumContentHorizontalPadding, vertical = 6.dp)
                .weight(1.0f)
                .fillMaxWidth()
                .clickable(video.onClick),
            adViewModel = video.vastAdViewModel,
            backgroundColor = Color.Black,
            replayButton = null,
            adCloseCountdownButton = null,
            adSkipCountdownButton = null,
            ctaButton = null,
            overrideVastContainerOnClick = OverrideVastContainerOnClick(
                overrideLinearOnClick = data.video.onClick,
                overrideCompanionOnClick = data.video.onClick,
                overrideDECOnClick = data.video.onClick
            ),
            progressBar = null,
            viewVisibilityTracker = viewVisibilityTracker,
        )
    }
}

@Composable
@Preview(showBackground = true)
private fun NativeMediumVideoPreview() {
    MaterialTheme {
        NativeMediumVideo(
            modifier = Modifier.size(300.dp, 250.dp),
            viewVisibilityTracker = SdkObjectFactory.Miscellaneous.viewVisibilityTrackerFactory,
            data = NativeMediumVideoData(
                video = NativeMediumVideoData.Video(
                    vastAdViewModel = object : AdViewModel {
                        override val canReplay: StateFlow<Boolean> = MutableStateFlow(false)

                        override fun onReplay() {}

                        override val goNextAction: StateFlow<GoNextAction.State>
                            get() = MutableStateFlow(GoNextAction.State.Available)

                        override fun goNextAdPartOrDismissAd() {
                        }

                        override val ctaAvailable: StateFlow<Boolean> = MutableStateFlow(true)

                        override fun onCTA() {}

                        override val currentAdPart: StateFlow<AdViewModel.AdPart?> =
                            MutableStateFlow(
                                AdViewModel.AdPart.Linear(
                                    object : LinearViewModel {
                                        override val videoUri: String = "https://file-examples.com/storage/fee472ce6e64b122ba0c8b3/2017/04/file_example_MP4_640_3MG.mp4"
                                        override val isStreamingEnabled: Boolean
                                            get() = false
                                        override val startFromMillis =
                                            MutableStateFlow(ValueWrapper(0L))
                                        override val mute = MutableStateFlow(true)
                                        override fun onMuteChange(mute: Boolean) { }
                                        override val vastPrivacyIcon =
                                            MutableStateFlow<PreparedVastResource?>(null)
                                        override fun onVastPrivacyIconClick() {}
                                        override fun onVastPrivacyIconDisplayed() {}

                                        override fun onSkip() { }
                                        override fun onIsPlaying(isPlaying: Boolean) { }
                                        override fun onProgress(progress: PlaybackProgress) { }
                                        override fun onError(error: VastAdShowError) { }
                                        override fun onDisplayStarted() { }
                                        override fun onVideoPlayerVisible() { }

                                        override fun onVideoPlayerNotVisible() { }

                                        override val goNextAction: StateFlow<GoNextAction.State>
                                            get() = MutableStateFlow(GoNextAction.State.Available)
                                        override val hasClickThrough: Boolean
                                            get() = true

                                        override fun onClickThrough(
                                            position: CustomUserEventBuilderService.UserInteraction.Position
                                        ) {}
                                        override fun onButtonRendered(
                                            button: CustomUserEventBuilderService.UserInteraction.Button
                                        ) {}
                                        override fun onButtonUnRendered(
                                            buttonType: CustomUserEventBuilderService.UserInteraction.Button.ButtonType
                                        ) {}

                                        override fun destroy() {}
                                    },
                                    isLastAdPart = false
                                )
                            )

                        override fun onButtonRendered(
                            button: CustomUserEventBuilderService.UserInteraction.Button
                        ) {}

                        override fun onButtonUnRendered(
                            buttonType: CustomUserEventBuilderService.UserInteraction.Button.ButtonType
                        ) {
                        }
                    },
                    onClick = { }
                ),
                icon = NativeTemplateBaseData.Image(
                    uri = "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTJGMIttEjf8B1rP9xaWUviUNJBuGjpTCc-7GpRW5Ue&s",
                    onClick = { }
                ),
                title = NativeTemplateBaseData.TextField(
                    text = "Bubble Pop! Puzzle Game Legend",
                    onClick = { }
                ),
                sponsored = NativeTemplateBaseData.TextField(
                    text = "Bitmango",
                    onClick = { }
                ),
                rating = NativeTemplateBaseData.Rating(4F, 5, onClick = { }),
                cta = NativeTemplateBaseData.CTA(
                    text = "Download Now",
                    onClick = { }
                ),
                privacyOnClick = { },
                mainLinkOnClick = { }
            )
        )
    }
}
