package com.moloco.sdk.internal.publisher.nativead.ui.templates

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.moloco.sdk.internal.publisher.nativead.ui.CTASmall
import com.moloco.sdk.internal.publisher.nativead.ui.IconImageSmall
import com.moloco.sdk.internal.publisher.nativead.ui.RatingSmall
import com.moloco.sdk.internal.publisher.nativead.ui.SponsorTextSmall
import com.moloco.sdk.internal.publisher.nativead.ui.TitleSmall

@Composable
internal fun NativeSmall(modifier: Modifier = Modifier, data: NativeTemplateBaseData) {
    NativeContainer(
        modifier = modifier,
        showSponsoredLabel = data.sponsored != null,
        privacyOnClick = data.privacyOnClick,
        containerOnClick = data.mainLinkOnClick
    ) { hasHeader ->

        Row(
            modifier = Modifier.padding(
                start = NativeMediumContentHorizontalPadding,
                end = NativeMediumContentHorizontalPadding,
                top = if (hasHeader) 0.dp else ContentVerticalPadding,
                bottom = ContentVerticalPadding
            ),
            verticalAlignment = Alignment.CenterVertically
        ) {
            val icon = data.icon
            IconImageSmall(
                imageUri = icon.uri,
                onClick = icon.onClick
            )

            Column(
                modifier = Modifier.padding(start = AssetHorizontalPadding)
            ) {
                val title = data.title
                TitleSmall(text = title.text, onClick = title.onClick)

                Row {
                    Column(
                        modifier = Modifier.weight(1.0f)
                    ) {
                        val sponsored = data.sponsored
                        if (sponsored != null) {
                            SponsorTextSmall(text = sponsored.text, onClick = sponsored.onClick)
                        }

                        val rating = data.rating
                        if (rating != null) {
                            RatingSmall(
                                stars = rating.stars.toInt(),
                                outOf = rating.outOf,
                                onClick = rating.onClick
                            )
                        }
                    }

                    val cta = data.cta
                    CTASmall(
                        Modifier.padding(start = AssetHorizontalPadding),
                        text = cta.text,
                        onClick = cta.onClick
                    )
                }
            }
        }
    }
}

private val ContentHorizontalPadding = 14.dp
private val ContentVerticalPadding = 18.dp
private val AssetHorizontalPadding = 10.dp

@Composable
@Preview(showBackground = true)
private fun NativeSmallPreview() {
    MaterialTheme {
        NativeSmall(
            modifier = Modifier.size(320.dp, 100.dp),
            data = NativeTemplateBaseData(
                icon = NativeTemplateBaseData.Image(
                    uri = "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTJGMIttEjf8B1rP9xaWUviUNJBuGjpTCc-7GpRW5Ue&s",
                    onClick = { }
                ),
                title = NativeTemplateBaseData.TextField(
                    text = "Bubble Pop! Puzzle Game Legend",
                    onClick = { }
                ),
                sponsored = NativeTemplateBaseData.TextField(
                    text = "Bitmango",
                    onClick = { }
                ),
                rating = NativeTemplateBaseData.Rating(4F, 5, onClick = { }),
                cta = NativeTemplateBaseData.CTA(
                    text = "Download Now",
                    onClick = { }
                ),
                privacyOnClick = { },
                mainLinkOnClick = { }
            )
        )
    }
}
