package com.moloco.sdk.internal.publisher.nativead.ui.templates

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.AdViewModel

internal typealias NativeAssetOnClick = (() -> Unit)?

internal open class NativeTemplateBaseData(
    val title: TextField,
    val sponsored: TextField?,
    val icon: Image,
    val rating: Rating?,
    val cta: CTA,
    val privacyOnClick: NativeAssetOnClick,
    val mainLinkOnClick: NativeAssetOnClick
) {
    class TextField(
        val text: String,
        val onClick: NativeAssetOnClick,
    )

    class Image(
        val uri: String,
        val onClick: NativeAssetOnClick
    )

    class Rating(
        val stars: Float,
        val outOf: Int,
        val onClick: NativeAssetOnClick
    )

    class CTA(
        val text: String,
        val onClick: () -> Unit
    )
}

internal class NativeMediumImageData(
    val mainImage: Image,
    title: TextField,
    sponsored: TextField?,
    icon: Image,
    rating: Rating?,
    cta: CTA,
    privacyOnClick: NativeAssetOnClick,
    mainLinkOnClick: NativeAssetOnClick
) : NativeTemplateBaseData(
    title,
    sponsored,
    icon,
    rating,
    cta,
    privacyOnClick,
    mainLinkOnClick
)

internal class NativeMediumVideoData(
    val video: Video,
    title: TextField,
    sponsored: TextField?,
    icon: Image,
    rating: Rating?,
    cta: CTA,
    privacyOnClick: NativeAssetOnClick,
    mainLinkOnClick: NativeAssetOnClick
) : NativeTemplateBaseData(
    title,
    sponsored,
    icon,
    rating,
    cta,
    privacyOnClick,
    mainLinkOnClick
) {

    class Video(
        val vastAdViewModel: AdViewModel,
        val onClick: NativeAssetOnClick
    )
}
