package com.moloco.sdk.internal.services

import android.content.Context
import com.google.android.gms.ads.identifier.AdvertisingIdClient

internal interface AdDataService {
    fun advertisingData(): AdData
}

internal sealed class AdData {
    data class Available(val id: String) : AdData()
    object Unavailable : AdData()
}

internal class AdDataServiceImpl(private val context: Context) : AdDataService {
    override fun advertisingData(): AdData {
        return runCatching {
            AdvertisingIdClient.getAdvertisingIdInfo(context)
        }.getOrNull()?.run {
            if (isLimitAdTrackingEnabled) {
                AdData.Unavailable
            } else {
                id?.run { AdData.Available(this) }
            }
        } ?: AdData.Unavailable
    }
}
