package com.moloco.sdk.internal.services

import android.content.Context
import android.media.AudioManager
import android.os.Build
import androidx.core.content.ContextCompat
import com.moloco.sdk.internal.MolocoLogger

internal interface AudioService {
    val isMediaVolumeOnMute: Boolean
}

internal class AudioServiceImpl(
    context: Context
) : AudioService {

    val audioManager: AudioManager? = try {
        ContextCompat.getSystemService(
            context.applicationContext,
            AudioManager::class.java
        )
    } catch (e: Exception) {
        MolocoLogger.error(TAG, "couldn't get android.media.AudioManager service", e)
        null
    }

    override val isMediaVolumeOnMute: Boolean
        get() =
            // In case audio manager is unavailable, fall back to "mute" value.
            if (audioManager == null) {
                true
            } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                audioManager.isStreamMute(StreamMusic)
            } else {
                audioManager.getStreamVolume(StreamMusic) == 0
            }
}

private const val TAG = "AudioService"

private const val StreamMusic = AudioManager.STREAM_MUSIC
