package com.moloco.sdk.internal.services

import android.content.Context
import android.content.res.Resources
import android.os.Build
import android.os.SystemClock
import android.telephony.TelephonyManager
import androidx.core.content.ContextCompat
import com.moloco.sdk.R
import java.util.Locale

internal interface DeviceInfoService {
    operator fun invoke(): DeviceInfo
}

internal data class DeviceInfo(
    val manufacturer: String,
    val model: String,
    val hwVersion: String,
    val isTablet: Boolean,
    val os: String,
    val osVersion: String,
    val apiLevel: Int,
    val language: String,
    val mobileCarrier: String,
    val screenDensity: Float,
    val dbtMs: Long,
)

internal class AndroidDeviceInfoService(private val context: Context) : DeviceInfoService {

    private val isTablet: Boolean by lazy {
        context.resources.getBoolean(R.bool.isTablet)
    }

    override fun invoke() = DeviceInfo(
        Build.MANUFACTURER ?: "",
        Build.MODEL ?: "",
        Build.HARDWARE ?: "",
        isTablet,
        "android",
        Build.VERSION.RELEASE,
        Build.VERSION.SDK_INT,
        Locale.getDefault().language,
        ContextCompat.getSystemService(context, TelephonyManager::class.java)
            ?.networkOperatorName ?: "",
        Resources.getSystem().displayMetrics.density,
        System.currentTimeMillis() - SystemClock.elapsedRealtime(),
    )
}
