package com.moloco.sdk.internal.services

import android.content.Context
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.ScreenService

/**
 * Duplicate functionality to [ScreenService]. The default implementation just forwards calls to
 * [ScreenService].
 *
 * TODO - Remove this class and use [ScreenService] directly - https://mlc.atlassian.net/browse/SDK-2355
 */
internal interface ScreenInfoService {
    operator fun invoke(): ScreenInfo
}

internal data class ScreenInfo(
    val screenWidthPx: Int,
    val screenWidthDp: Float,
    val screenHeightPx: Int,
    val screenHeightDp: Float,
    val density: Float,
    val dpi: Int,
)

internal class ScreenInfoServiceImpl(val context: Context) : ScreenInfoService {
    override fun invoke(): ScreenInfo = ScreenService(context).invoke().let {
        ScreenInfo(
            screenWidthDp = it.widthDp,
            screenWidthPx = it.widthPx,
            screenHeightDp = it.heightDp,
            screenHeightPx = it.heightPx,
            density = it.pxRatio,
            dpi = it.dpi
        )
    }
}
