package com.moloco.sdk.internal.services.usertracker

import java.util.UUID

internal interface UserTrackerIdentifierGenerator {
    /**
     * Generates a unique identifier
     */
    fun generate(): String
}

internal class UUIDUserIdentifierGenerator : UserTrackerIdentifierGenerator {
    override fun generate(): String {
        return UUID.randomUUID().toString()
    }
}
