package com.moloco.sdk.internal.services.usertracker

import kotlinx.coroutines.sync.Mutex
import kotlinx.coroutines.sync.withLock

interface UserTrackerService {
    /**
     * Clears the tracking identifier of the user
     */
    suspend fun clear()

    /**
     * Retrieves the tracking identifier of the user. Internally generates a new
     * one if it doesn't already exist.
     */
    suspend fun getIdentifier(): String
}

internal class UserTrackerServiceImpl(
    private val idGenerator: UserTrackerIdentifierGenerator,
    private val idRepository: UserIdentifierRepository
) : UserTrackerService {

    // We execuate all calls in this service in the dedicated mutex lock so that
    // we can ensure concurrency safety
    private val mutex = Mutex()

    override suspend fun clear() = mutex.withLock {
        idRepository.clear()
    }

    override suspend fun getIdentifier(): String = mutex.withLock {
        var currentId = idRepository.get()
        if (currentId == null) {
            currentId = idGenerator.generate()
            idRepository.persist(currentId)
        }

        currentId
    }
}
