package com.moloco.sdk.publisher

/**
 * Represents the types of ad formats.
 */
enum class AdFormatType {
    BANNER,
    INTERSTITIAL,
    REWARDED,
    MREC,
    NATIVE_SMALL_IMAGE,
    NATIVE_MEDIUM_IMAGE,
    NATIVE_MEDIUM_VIDEO,
    ;

    /**
     * Returns the lowercase string representation of the enum constant.
     */
    fun toLowercase() = toString().lowercase()

    /**
     * Returns the titlecase string representation of the enum constant.
     */
    fun toTitlecase() = toLowercase().replaceFirstChar {
        if (it.isLowerCase()) it.titlecase() else it.toString()
    }
}
