package com.moloco.sdk.publisher

import android.app.Activity
import android.os.Bundle
import android.os.PersistableBundle
import android.view.ViewGroup
import android.widget.FrameLayout
import com.moloco.sdk.publisher.MolocoAdError.AdCreateError


private class BannerActivitySample : Activity() {

    private val bannerContainer = FrameLayout(this)

    private lateinit var banner: Banner

    @Suppress("UNUSED_ANONYMOUS_PARAMETER")
    override fun onCreate(savedInstanceState: Bundle?, persistentState: PersistableBundle?) {
        super.onCreate(savedInstanceState, persistentState)
        setContentView(bannerContainer)

        // Once Moloco SDK is initialized, let's create a banner.
        Moloco.createBanner(adUnitId = "MOLOCO_ADUNIT_ID") { banner: Banner?, adCreateError: AdCreateError? ->
            if (banner == null) {
                /**
                 * Weren't able to create ad due to [AdCreateError].
                 */
                finish()
                return@createBanner
            }

            this.banner = banner
            // Add the banner to the ViewGroup.
            bannerContainer.addView(banner)

            // Attach an optional listener for ad show events.
            banner.adShowListener = object : BannerAdShowListener {
                override fun onAdShowSuccess(molocoAd: MolocoAd) {
                    TODO("Not yet implemented")
                }

                override fun onAdShowFailed(molocoAdError: MolocoAdError) {
                    TODO("Not yet implemented")
                }

                override fun onAdHidden(molocoAd: MolocoAd) {
                    TODO("Not yet implemented")
                }

                override fun onAdClicked(molocoAd: MolocoAd) {
                    TODO("Not yet implemented")
                }
            }

            // Fetch a bid response...

            // Load a successful bid response into banner object.
            // You can choose to listen to ad load events as well.
            banner.load(
                bidResponseJson = "bid response",
                listener = object : AdLoad.Listener {
                    override fun onAdLoadSuccess(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }

                    override fun onAdLoadFailed(molocoAdError: MolocoAdError) {
                        TODO("Not yet implemented")
                    }
                }
            )

            // banner load status can also be checked by calling
            banner.isLoaded

            // Once banner is loaded it'll automatically display an ad
            // as long as its added to the screen and visible.

            // In order to load an another banner, call load() method again with a new bid response.
            banner.load(bidResponseJson = "an_another_bid_response", listener = null)

            // Banner can be loaded and added/removed from view hierarchy independently and in any order.
            // For example this call sequence:
            bannerContainer.removeView(banner)
            banner.load("", null)
            banner.load("some_other_bid_response", null)
            bannerContainer.addView(banner)
            // will work just as well as a previous example.
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        // Release resources when banner is not needed anymore and/or to prevent memory leaks;
        // example here: activity is about to be destroyed.
        banner.destroy()
        (banner.parent as? ViewGroup)?.removeView(banner)
    }
}
