@file:Suppress("unused", "UNUSED_ANONYMOUS_PARAMETER", "ControlFlowWithEmptyBody", "UNUSED_PARAMETER", "UNUSED_VARIABLE")

package com.moloco.sdk.publisher

import android.content.Context
import android.widget.FrameLayout
import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.publisher.MolocoAdError.AdCreateError
import com.moloco.sdk.publisher.init.MolocoInitParams
import org.json.JSONArray
import org.json.JSONObject

private fun MolocoInitializeSample(appContext: Context) {
    // Create a proper MediationInfo instance for enabling Bid Token API.
    // Then, pass it to initialize().
    val mediationInfo = MediationInfo("<YourMediationName>")

    Moloco.initialize(
        MolocoInitParams(appContext, "YOUR_APP_KEY", mediationInfo)
    ) { molocoInitStatus ->
        if (molocoInitStatus.initialization == Initialization.SUCCESS) {
            // ready to create, load and show ad units.

            // Bid Token API is available now as well (if mediationInfo was passed into initialize()).
            Moloco.getBidToken { bidToken: String, error ->
                // ..
            }
        } else {
            // Initialization error.
            MolocoLogger.error("app", molocoInitStatus.description)
        }
    }
}

private fun MolocoIsInitializedSample() {
    if (Moloco.isInitialized) {
        // ready to create, load and show ad units.
    } else {
        // Not initialized yet.
    }
}

private fun MolocoCreateBanner(frameLayout: FrameLayout) {
    /**
     * createXXX calls requires [Moloco.initialize] to have been invoked
     */
    Moloco.createBanner("MOLOCO_ADUNIT_ID") { banner: Banner?, adCreateError: AdCreateError? ->
        if (banner != null) {
            banner.load("bid_response", listener = null)
            frameLayout.addView(banner)
            // ...
            banner.destroy()
            frameLayout.removeView(banner)
        } else {
            // Use the `adCreateError` to determine the error
        }
    }
}

private fun MolocoCreateBannerTablet(frameLayout: FrameLayout) {
    /**
     * createXXX calls requires [Moloco.initialize] to have been invoked
     */
    Moloco.createBannerTablet("MOLOCO_ADUNIT_ID") { banner: Banner?, adCreateError: AdCreateError? ->
        if (banner != null) {
            banner.load("bid_response", listener = null)
            frameLayout.addView(banner)
            // ...
            banner.destroy()
            frameLayout.removeView(banner)
        } else {
            // Use the `adCreateError` to determine the error
        }
    }
}

private fun MolocoCreateNativeAd(adUnitId: String) {
    /**
     * createXXX calls requires [Moloco.initialize] to have been invoked
     */
    Moloco.createNativeAd("MOLOCO_ADUNIT_ID") { nativeAd: NativeAdForMediation?, molocoAdCreateError: AdCreateError? ->
        if (nativeAd != null) {
            val requirements: NativeAdOrtbRequestRequirements.Requirements = nativeAd.nativeAdOrtbRequestRequirements
            // Bid Request specs to be sent per ORTB specs for Native Ads. This is for Mediation side
            // bidRequestNativeAdOrtbParams(requirements)

            // Load native ad ...
            nativeAd.load("bid_response", listener = null)
        } else {
            // Use the `adCreateError` to determine the error
        }
    }

    /**
     * Example of how one can build the bid request specs for Native Ads per ORTB
     */
    fun bidRequestNativeAdOrtbParams(requirements: NativeAdOrtbRequestRequirements.Requirements) =
        JSONObject().apply {
            val nativeVer = "1.2"

            put(
                "native",
                JSONObject().apply {
                    put("ver", nativeVer)
                    put(
                        "request",
                        JSONObject().apply {
                            put("ver", nativeVer)

                            put("privacy", 1)

                            put(
                                "eventtrackers",
                                JSONArray().apply {
                                    requirements.eventTrackers.forEach {
                                        put(
                                            JSONObject().apply {
                                                put("event", it.eventType)
                                                put("methods", JSONArray(it.methodTypes))
                                            }
                                        )
                                    }
                                }
                            )

                            put(
                                "assets",
                                JSONArray().apply {
                                    requirements.assets.values.forEach {
                                        put(
                                            JSONObject().apply {
                                                put("id", it.id)
                                                put("required", if (it.required) 1 else 0)

                                                when (it) {
                                                    is NativeAdOrtbRequestRequirements.Requirements.Asset.Data -> put(
                                                        "data",
                                                        JSONObject().apply {
                                                            put("type", it.type)
                                                            it.len?.let { len -> put("len", len) }
                                                        }
                                                    )

                                                    is NativeAdOrtbRequestRequirements.Requirements.Asset.Image -> put(
                                                        "img",
                                                        JSONObject().apply {
                                                            it.type?.let { type ->
                                                                put(
                                                                    "type",
                                                                    type
                                                                )
                                                            }
                                                            put("wmin", 1)
                                                            put("hmin", 1)
                                                        }
                                                    )

                                                    is NativeAdOrtbRequestRequirements.Requirements.Asset.Title -> put(
                                                        "title",
                                                        JSONObject().apply {
                                                            put("len", it.length)
                                                        }
                                                    )

                                                    is NativeAdOrtbRequestRequirements.Requirements.Asset.Video -> put(
                                                        "video",
                                                        JSONObject().apply {
                                                            put(
                                                                "mimes",
                                                                JSONArray().apply {
                                                                    put("video/mp4")
                                                                    put("video/3gpp")
                                                                    put("video/3gpp2")
                                                                    put("video/x-m4v")
                                                                    put("video/quicktime")
                                                                }
                                                            )
                                                            put(
                                                                "protocols",
                                                                JSONArray().apply {
                                                                    // Vast 2-4 + Vast Wrapper support.
                                                                    put(2)
                                                                    put(3)
                                                                    put(4)
                                                                    put(5)
                                                                    put(6)
                                                                    put(7)
                                                                }
                                                            )
                                                        }
                                                    )
                                                }
                                            }
                                        )
                                    }
                                }
                            )
                        }
                    )
                }
            )
        }
}

private fun MolocoCreateInterstitialAd() {
    /**
     * createXXX calls requires [Moloco.initialize] to have been invoked
     */
    Moloco.createInterstitial("MOLOCO_ADUNIT_ID") { interstitial: InterstitialAd?, adCreateError: AdCreateError? ->
        if (interstitial != null) {
            interstitial.load("bid_response", listener = null)
            // ...
            interstitial.show(listener = null)
            // ...
            interstitial.destroy()
        } else {
            // Use the `adCreateError` to determine the error
        }
    }

}

private fun MolocoCreateRewardedInterstitialAd() {
    /**
     * createXXX calls requires [Moloco.initialize] to have been invoked
     */
    Moloco.createRewardedInterstitial("MOLOCO_ADUNIT_ID") { rewarded: RewardedInterstitialAd?, adCreateError: AdCreateError? ->
        if (rewarded != null) {
            rewarded.load("bid_response", listener = null)
            // ...
            rewarded.show(listener = null)
            // ...
            rewarded.destroy()
        } else {
            // Use the `adCreateError` to determine the error
        }
    }
}
