package com.moloco.sdk.publisher

import android.content.Context

/**
 * A native banner ad base class which extends the [Banner] class.
 * Also implements [NativeAdOrtbRequestRequirements] interface which is essential for a proper bid request generation.
 *
 * General usage is the same as for [Banner]. The only difference is
 * in order to get a proper mapping between bid request and response's native assets (ids and whatnot)
 * use [nativeAdOrtbRequestRequirements][NativeAdOrtbRequestRequirements.nativeAdOrtbRequestRequirements] property.
 *
 * @property activity The activity to which the banner is attached
 * @property adShowListener The listener to handle banner ad show/hide events
 *
 * @sample com.moloco.sdk.publisher.NativeBannerActivitySample
 */
abstract class NativeBanner(
    context: Context,
) : Banner(context), NativeAdOrtbRequestRequirements {
    init {
        tag = "MolocoNativeBannerView"
    }
}
