package com.moloco.sdk.publisher

import android.app.Activity
import android.os.Bundle
import android.os.PersistableBundle
import android.view.ViewGroup
import android.widget.FrameLayout

private class NativeBannerActivitySample : Activity() {

    private val nativeBannerContainer = FrameLayout(this)

    private lateinit var nativeBanner: NativeBanner

    override fun onCreate(savedInstanceState: Bundle?, persistentState: PersistableBundle?) {
        super.onCreate(savedInstanceState, persistentState)
        setContentView(nativeBannerContainer)

        // Once Moloco SDK is initialized, let's create a native banner.
        Moloco.createNativeBanner(adUnitId = "MOLOCO_ADUNIT_ID") {nativeBanner ->
            if (nativeBanner == null) {
                // Weren't able to create native banner due to Moloco SDK not initialized or invalid ad unit id.
                finish()
                return@createNativeBanner
            }

            this.nativeBanner = nativeBanner
            // Add the native banner to the ViewGroup.
            nativeBannerContainer.addView(nativeBanner)

            // Attach an optional listener for ad show events.
            nativeBanner.adShowListener = object : BannerAdShowListener {
                override fun onAdShowSuccess(molocoAd: MolocoAd) {
                    TODO("Not yet implemented")
                }

                override fun onAdShowFailed(molocoAdError: MolocoAdError) {
                    TODO("Not yet implemented")
                }

                override fun onAdHidden(molocoAd: MolocoAd) {
                    TODO("Not yet implemented")
                }

                override fun onAdClicked(molocoAd: MolocoAd) {
                    TODO("Not yet implemented")
                }
            }

            // Fetch a bid response by sending a native ad bid request based on
            nativeBanner.nativeAdOrtbRequestRequirements

            // Load a successful bid response into native banner object.
            // You can choose to listen to ad load events as well.
            nativeBanner.load(
                bidResponseJson = "bid response",
                listener = object : AdLoad.Listener {
                    override fun onAdLoadSuccess(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }

                    override fun onAdLoadFailed(molocoAdError: MolocoAdError) {
                        TODO("Not yet implemented")
                    }
                }
            )

            // native banner load status can also be checked by calling
            nativeBanner.isLoaded

            // Once native banner is loaded it'll automatically display an ad
            // as long as its added to the screen and visible.

            // In order to load an another native banner, call load() method again with a new bid response.
            nativeBanner.load(bidResponseJson = "an_another_bid_response", listener = null)

            // Banner can be loaded and added/removed from view hierarchy independently and in any order.
            // For example this call sequence:
            nativeBannerContainer.removeView(nativeBanner)
            nativeBanner.load("", null)
            nativeBanner.load("some_other_bid_response", null)
            nativeBannerContainer.addView(nativeBanner)
            // will work just as well as a previous example.
        }

    }

    override fun onDestroy() {
        super.onDestroy()
        // Release resources when native banner is not needed anymore and/or to prevent memory leaks;
        // example here: activity is about to be destroyed.
        nativeBanner.destroy()
        (nativeBanner.parent as? ViewGroup)?.removeView(nativeBanner)
    }
}
