package com.moloco.sdk.publisher.bidrequest

import com.moloco.sdk.Init.SDKInitResponse
import kotlinx.serialization.Serializable

@Serializable
data class Geo(
    val city: String?,
    val country: String?,
    val region: String?,
    val zipCode: String?,
    val latitude: Float?,
    val longitude: Float?,
)

fun SDKInitResponse.Geo.toGeo(): Geo {
    return Geo(
        city = city,
        country = countryIso3Code,
        region = countryIso2Code,
        zipCode = zipCode,
        latitude = latitude,
        longitude = longitude
    )
}
