package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer

import androidx.compose.runtime.Composable
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.AdCountdownButton
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.defaultAdCloseCountdownButton
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview.AdWebViewRenderer
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview.defaultAdWebViewRenderer
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.VastRenderer
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.defaultVastRenderer

/**
 * @param closeDelaySeconds null - close functionality available immediately
 * @param AdWebViewRenderer layout for rendering WebView based ad
 * @param decGoNextActionDelaySeconds delay seconds for displaying the next ad part
 * @param decClose dec close button data
 */
internal class AdWebViewOptions(
    val closeDelaySeconds: Int = DEFAULT_CLOSE_DELAY_SECONDS,
    val AdWebViewRenderer: AdWebViewRenderer = defaultAdWebViewRenderer(),
    val decGoNextActionDelaySeconds: Int = DEFAULT_CLOSE_DELAY_SECONDS,
    val decClose: @Composable () -> AdCountdownButton? = { defaultAdCloseCountdownButton() }
)

/**
 * @param startMuted whether video starts muted or not
 * @param overrideLinearGoNextActionEnabled null: VAST linear skip/"go next" action availability relies on VAST xml ad markup's <Skippable> tag value; otherwise skip availability is decided by the Boolean value of this parameter.
 * @param overrideLinearGoNextActionEnabledDelaySeconds ignored when [overrideLinearGoNextActionEnabled] is null; otherwise skip action availability delay is decided by the Int value of this parameter.
 * @param companionGoNextActionDelaySeconds amount of seconds till "go next" action is available for Companion(endcard) ad parts.
 * @param decGoNextActionDelaySeconds amount of seconds till "go next" action is available for DEC ad parts.
 * @param autoStoreOnSkip Moloco feature: if user clicks skip button, open clicktrough link without VAST click tracking.
 * @param autoStoreOnComplete Moloco feature: if video completes, open clicktrough link without VAST click tracking.
 * @param VastRenderer layout for rendering VAST ad
 */
class VastOptions(
    val startMuted: Boolean = true,
    val overrideLinearGoNextActionEnabled: Boolean? = null,
    val overrideLinearGoNextActionEnabledDelaySeconds: Int = 5,
    val companionGoNextActionDelaySeconds: Int = DEFAULT_CLOSE_DELAY_SECONDS,
    val decGoNextActionDelaySeconds: Int = DEFAULT_CLOSE_DELAY_SECONDS,
    val autoStoreOnSkip: Boolean = false,
    val autoStoreOnComplete: Boolean = false,
    val VastRenderer: VastRenderer = defaultVastRenderer()
)

/**
 * @param vastOptions - options for a simple html ad
 * @param mraidOptions - options for a simple html ad
 * @param staticOptions - options for a simple html ad
 */
internal class AggregatedOptions(
    val vastOptions: VastOptions,
    val mraidOptions: AdWebViewOptions,
    val staticOptions: AdWebViewOptions
)

const val DEFAULT_CLOSE_DELAY_SECONDS = 5
