package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer

import android.content.Context
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.NativeAdImpl
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.PreparedNativeAssets
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.MainScope

/**
 * Native ad interface providing everything needed for native asset loading, stitching, event tracking etc.
 * Does not provide stitched view as opposed to [NativeBanner] implementation of [Banner].
 * Can be used for custom view rendering and interaction implementation
 * @param adm - ad markup; ad data to load and render,
 * @param impressionTrackingUrlTransformer - in case there's a need to change impression event's (or url from imptracker array) urls (for example: macroses substitution),
 * you can do it here;
 */
fun NativeAd(
    context: Context,
    adm: String,
    scope: CoroutineScope = MainScope(),
    externalLinkHandler: ExternalLinkHandler,
    persistentHttpRequest: PersistentHttpRequest,
    impressionTrackingUrlTransformer: (url: String) -> String = DoNotTransformUrl
): NativeAd = NativeAdImpl(
    context,
    adm,
    scope,
    externalLinkHandler,
    persistentHttpRequest,
    impressionTrackingUrlTransformer
)

/**
 * Native ad interface providing everything needed for native asset loading, stitching, event tracking etc.
 * Does not provide stitched view as opposed to [NativeBanner] implementation of [Banner].
 * Can be used for custom view rendering and interaction implementation
 */
interface NativeAd : AdLoad {

    /**
     * Preloaded, ready-to-use native assets for native ad view stitching
     * according to IAB's native ad [specs](https://www.iab.com/wp-content/uploads/2018/03/OpenRTB-Native-Ads-Specification-Final-1.2.pdf)
     *
     * null - if [load][AdLoad.load] failed or hasn't been invoked yet.
     */
    val preparedAssets: PreparedNativeAssets?

    /**
     * Handle asset click: tracks + opens link if possible
     * according to IAB's native ad [specs](https://www.iab.com/wp-content/uploads/2018/03/OpenRTB-Native-Ads-Specification-Final-1.2.pdf)
     *
     * @param assetId - id of asset clicked; null - native view container/general area click
     * @return true if click was handled properly (tracked and link opened)
     */
    fun handleAssetClick(assetId: Int?): Boolean

    /**
     * Decide whether to show privacy button on native ad view.
     */
    val privacyButtonRequired: Boolean

    /**
     * Opens privacy web link if available
     * according to IAB's native ad [specs](https://www.iab.com/wp-content/uploads/2018/03/OpenRTB-Native-Ads-Specification-Final-1.2.pdf)
     */
    fun handlePrivacyClick()

    /**
     * Tracks native ad impression when triggered
     * according to IAB's native ad [specs](https://www.iab.com/wp-content/uploads/2018/03/OpenRTB-Native-Ads-Specification-Final-1.2.pdf)
     */
    fun trackImpression()
}
