package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer

import android.content.Context
import android.view.View
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MolocoAdSubErrorType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.NativeBannerImpl
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.PreparedNativeAssets
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.doNotTransformUrl
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest

/**
 * Banner that resolves ad type (mraid, vast etc) automatically.
 * @param adm - ad markup; ad data to load and render,
 * @param nativeAdViewProvider - provide UI for the native ad, connect respective native event callbacks and data there.
 * @param impressionTrackingUrlTransformer - in case there's a need to change impression event's (or url from imptracker array) urls (for example: macroses substitution),
 * you can do it here;
 */
fun NativeBanner(
    context: Context,
    customUserEventBuilderService: CustomUserEventBuilderService,
    adm: String,
    nativeAdViewProvider: NativeAdViewProvider,
    viewVisibilityTracker: ViewVisibilityTracker,
    externalLinkHandler: ExternalLinkHandler,
    persistentHttpRequest: PersistentHttpRequest,
    impressionTrackingUrlTransformer: (url: String) -> String = DoNotTransformUrl
): Banner<NativeAdShowListener> = NativeBannerImpl(
    context,
    customUserEventBuilderService,
    adm,
    nativeAdViewProvider,
    viewVisibilityTracker,
    externalLinkHandler,
    persistentHttpRequest,
    impressionTrackingUrlTransformer
)

interface NativeAdViewProvider : Destroyable {
    fun createNativeAdView(
        context: Context,
        customUserEventBuilderService: CustomUserEventBuilderService,
        assets: PreparedNativeAssets,
        onAssetClick: (assetId: Int?) -> Unit,
        onVastCompletionStatus: (skipped: Boolean) -> Unit,
        privacyButtonRequired: Boolean,
        viewVisibilityTracker: ViewVisibilityTracker,
        onPrivacyClick: () -> Unit,
        onError: (internalError: MolocoAdSubErrorType, assetId: Int?) -> Unit
    ): View?
}

val DoNotTransformUrl = ::doNotTransformUrl
