package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.media.stream

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.media.MediaCacheRepository
import java.io.File

internal val NotStarted = MediaStreamStatus.Progress(0, 0)

/**
 * Status of the media stream.
 */
internal sealed class MediaStreamStatus {
    data class Progress(val bytesDownloaded: Long, val totalBytes: Long)

    data class InProgress(val file: File, val progress: Progress) : MediaStreamStatus()
    data class Complete(val file: File) : MediaStreamStatus()
    data class Failure(val failure: MediaCacheRepository.Result.Failure) : MediaStreamStatus()
}