package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid

import android.content.Context
import android.util.TypedValue

// TODO. Refactor. I have pxToDp, dpToPx context extension, ScreenService as well.
internal object Dips {
    fun pixelsToFloatDips(pixels: Float, context: Context): Float {
        return pixels / getDensity(context)
    }

    fun pixelsToIntDips(pixels: Float, context: Context): Int {
        return (pixelsToFloatDips(pixels, context) + 0.5f).toInt()
    }

    fun dipsToFloatPixels(dips: Float, context: Context): Float {
        return dips * getDensity(context)
    }

    fun dipsToIntPixels(dips: Float, context: Context): Int {
        return (dipsToFloatPixels(dips, context) + 0.5f).toInt()
    }

    private fun getDensity(context: Context): Float {
        return context.resources.displayMetrics.density
    }

    fun asFloatPixels(dips: Float, context: Context): Float {
        val displayMetrics = context.resources.displayMetrics
        return TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dips, displayMetrics)
    }

    fun asIntPixels(dips: Float, context: Context): Int {
        return (asFloatPixels(dips, context) + 0.5f).toInt()
    }

    fun screenWidthAsIntDips(context: Context): Int {
        return pixelsToIntDips(context.resources.displayMetrics.widthPixels.toFloat(), context)
    }

    fun screenHeightAsIntDips(context: Context): Int {
        return pixelsToIntDips(context.resources.displayMetrics.heightPixels.toFloat(), context)
    }
}
