package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid

import android.webkit.WebView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Destroyable
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.AdPartClickThrough
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.GoNextAction
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.StateFlow

/**
 * Interface representing a controller for MRAID fullscreen content.
 * This controller handles events and actions specific to MRAID fullscreen experiences.
 */
internal interface MraidFullscreenContentController: MraidFullScreenViewModel, Destroyable {
    /**
     * The WebView instance used to display the MRAID content.
     */
    val webView: WebView

    /**
     * A StateFlow representing the expected screen orientation properties
     * set by the MRAID `setOrientationProperties` command.
     */
    val expectedOrientation: StateFlow<MraidJsCommand.SetOrientationProperties?>


    /**
     * A Flow representing events associated with the fullscreen controller,
     * such as skip or close actions, click-through events, and display started events.
     */
    val event: Flow<MraidFullscreenControllerEvent>

    /**
     * Handles the user action when the fullscreen content is skipped or closed.
     */
    fun onSkipOrClose()
}

/**
 * ViewModel interface for handling MRAID fullscreen display lifecycle events.
 * It defines actions to be performed when the display starts.
 */
interface MraidFullScreenViewModel: GoNextAction, AdPartClickThrough

/**
 * Enum representing different events related to MRAID fullscreen controller behavior.
 */
internal enum class MraidFullscreenControllerEvent {
    /**
     * Represents the event when the fullscreen content is skipped or closed by the user.
     */
    SkipOrClose,

    /**
     * Represents the event when the user clicks through the MRAID ad content.
     */
    ClickThrough
}
