package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid

import android.content.Context
import android.webkit.WebView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.AdWebViewOptions
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Watermark
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.Result
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MraidAdError

internal class MraidInline(
    context: Context,
    adm: String,
    private val onNeedToDetachAdViewBeforeExpand: () -> Unit,
    private val onExpandAdViewClosed: () -> Unit,
    onClick: () -> Unit,
    onError: (MraidAdError) -> Unit,
    // TODO. Refactor. Workaround for mraid endcard not crashing Vast player.
    forceBlockExpand: Boolean,
    externalLinkHandler: ExternalLinkHandler,
    watermark: Watermark?
) : MraidBaseAd(
    context,
    adm,
    MraidPlacementType.Inline,
    onClick,
    onError,
    AdWebViewOptions(),
    externalLinkHandler,
    forceBlockExpand,
    watermark
) {

    // TODO. Refactor whole MRAID.
    val webView: WebView
        get() = mraidBridge.webView

    suspend fun load(): WebView? {
        // error/load callbacks are already inside. I know, I know...
        return if (loadAndReadyMraid() is Result.Success) {
            mraidBridge.webView
        } else {
            null
        }
    }

    override fun onPreExpandAd() {
        super.onPreExpandAd()
        onNeedToDetachAdViewBeforeExpand()
    }

    override fun closeFullscreenAdRepresentation() {
        super.closeFullscreenAdRepresentation()
        onExpandAdViewClosed()
    }
}
