package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead

import android.content.Context
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.AdLoad
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.NativeAd
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest
import kotlinx.coroutines.CoroutineScope
import kotlin.time.Duration

internal class NativeAdImpl(
    context: Context,
    adm: String,
    scope: CoroutineScope,
    private val externalLinkHandler: ExternalLinkHandler,
    private val persistentHttpRequest: PersistentHttpRequest,
    private val impressionTrackingUrlTransformer: (url: String) -> String
) : NativeAd {

    private val adLoader: NativeAdLoader = NativeAdLoader(
        context,
        adm,
        scope
    )

    override val isLoaded by adLoader::isLoaded

    override fun load(timeout: Duration, listener: AdLoad.Listener?) {
        adLoader.load(timeout, listener)
    }

    override val preparedAssets by adLoader::preparedNativeAssets

    override val privacyButtonRequired: Boolean
        get() = adLoader.nativeOrtbResponse?.privacyUrl != null

    override fun handlePrivacyClick() {
        adLoader.nativeOrtbResponse?.privacyUrl?.let {
            externalLinkHandler(it)
        }
    }

    override fun trackImpression() {
        tracker?.trackImpressions()
    }

    override fun handleAssetClick(assetId: Int?): Boolean {
        val link = assetId?.let {
            adLoader.preparedNativeAssets?.allNonFailedAssets?.get(it)?.originAsset?.link
        } ?: adLoader.nativeOrtbResponse?.link ?: return false

        externalLinkHandler(link.url)
        tracker?.trackLink(link)

        return true
    }

    private var tracker: NativeAdTracker? = null
        get() {
            if (field == null) {
                val nativeOrtbResponse = adLoader.nativeOrtbResponse ?: return null

                field = NativeAdTracker(
                    nativeOrtbResponse.impressionTrackerUrls,
                    nativeOrtbResponse.eventTrackers,
                    persistentHttpRequest,
                    impressionTrackingUrlTransformer = impressionTrackingUrlTransformer
                )
            }

            return field
        }
}
