package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead

import android.content.Context
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.AdLoad
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.Result
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.AdLoadTimeoutError
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.NativeAdLoadError
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.TimeoutCancellationException
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import kotlinx.coroutines.withTimeout
import kotlin.time.Duration

internal class NativeAdLoader(
    private val context: Context,
    private val adm: String,
    private val scope: CoroutineScope,
) : AdLoad {

    var nativeOrtbResponse: NativeOrtbResponse? = null
    var preparedNativeAssets: PreparedNativeAssets? = null

    private val _isLoaded = MutableStateFlow(false)
    override val isLoaded: StateFlow<Boolean> = _isLoaded

    override fun load(timeout: Duration, listener: AdLoad.Listener?) {
        scope.launch {
            try {
                withTimeout(timeout) {
                    nativeOrtbResponse = (parseNativeOrtbResponse(adm) as? Result.Success)?.value

                    preparedNativeAssets = nativeOrtbResponse?.let {
                        (prepareNativeAssets(it.assets, context) as? Result.Success)?.value
                    }
                }
            } catch (e: TimeoutCancellationException) {
                listener?.onLoadTimeout(AdLoadTimeoutError.NATIVE_AD_LOAD_INTERNAL_TIMEOUT_ERROR)
                return@launch
            }

            if (nativeOrtbResponse == null) {
                listener?.onLoadError(NativeAdLoadError.NATIVE_AD_ORTB_RESPONSE_NULL_ERROR)
            } else if (preparedNativeAssets == null) {
                listener?.onLoadError(NativeAdLoadError.NATIVE_AD_PREPARED_ASSETS_NULL_ERROR)
            } else {
                _isLoaded.value = true
                listener?.onLoad()
            }
        }
    }
}
