package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead

import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest

internal class NativeAdTracker(
    private var impressionTrackerUrls: List<String>?,
    private var eventTrackers: List<NativeOrtbResponse.EventTracker>?,
    private val persistentHttpRequest: PersistentHttpRequest,
    private val impressionTrackingUrlTransformer: (url: String) -> String = ::doNotTransformUrl
) {
    fun trackImpressions() {
        impressionTrackerUrls?.forEach {
            persistentHttpRequest.send(
                impressionTrackingUrlTransformer(it)
            )
        }
        impressionTrackerUrls = null

        eventTrackers?.forEach { event ->
            if (event.url != null &&
                event.eventType == NativeOrtbEventTrackerEventType.Impression &&
                event.methodType == NativeOrtbEventTrackerMethodType.Image
            ) {
                persistentHttpRequest.send(
                    impressionTrackingUrlTransformer(event.url)
                )
            }
        }
        eventTrackers = null
    }

    private val trackedLinkUrls = mutableSetOf<String>()

    fun trackLink(link: NativeOrtbResponse.Link) {
        val urls = link.clickTrackerUrls
        for (url in urls) {
            if (!trackedLinkUrls.contains(url)) {
                persistentHttpRequest.send(url)
                trackedLinkUrls += url
            }
        }
    }
}

internal fun doNotTransformUrl(url: String): String = url
