package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead

import android.annotation.SuppressLint
import android.content.Context
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Banner
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.CreativeType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.NativeAd
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.NativeAdShowListener
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.NativeAdViewProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MolocoAdSubErrorType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.NativeAdShowError
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.launch

@SuppressLint("ViewConstructor")
internal class NativeBannerImpl(
    private val context: Context,
    private val customUserEventBuilderService: CustomUserEventBuilderService,
    adm: String,
    private val nativeAdViewProvider: NativeAdViewProvider,
    private val viewVisibilityTracker: ViewVisibilityTracker,
    externalLinkHandler: ExternalLinkHandler,
    persistentHttpRequest: PersistentHttpRequest,
    impressionTrackingUrlTransformer: (url: String) -> String
) : Banner<NativeAdShowListener>(context) {

    // TODO. Doesn't make sense for native ads, and yet, I have to implement it.
    override val creativeType: CreativeType? = null

    // TODO. Pass as constructor parameter.
    private val nativeAd = NativeAd(
        context,
        adm,
        scope,
        externalLinkHandler,
        persistentHttpRequest,
        impressionTrackingUrlTransformer,
    )

    override val adLoader by ::nativeAd

    override fun prepareAdViewForDisplay() {
        val preparedAssets = nativeAd.preparedAssets

        if (preparedAssets == null) {
            adShowListener?.onShowError(NativeAdShowError.NATIVE_AD_PREPARED_ASSETS_NULL_ERROR)
            return
        }

        scope.launch {
            isAdDisplaying.first { it }
            nativeAd.trackImpression()
        }

        val view = nativeAdViewProvider.createNativeAdView(
            context,
            customUserEventBuilderService,
            preparedAssets,
            ::onAssetClick,
            ::onVastCompletionStatus,
            nativeAd.privacyButtonRequired,
            viewVisibilityTracker,
            ::onPrivacyClick,
            ::onError
        )

        if (view == null) {
            adShowListener?.onShowError(NativeAdShowError.NATIVE_AD_VIEW_NULL_ERROR)
            return
        }

        adView = view
    }

    override fun destroy() {
        super.destroy()
        nativeAdViewProvider.destroy()
    }

    private fun onAssetClick(assetId: Int?) {
        if (nativeAd.handleAssetClick(assetId)) {
            adShowListener?.onClick()
        }
    }

    private fun onVastCompletionStatus(skipped: Boolean) {
        adShowListener?.onVastCompletionStatus(skipped)
    }

    private fun onPrivacyClick() {
        nativeAd.handlePrivacyClick()
    }

    private fun onError(internalError: MolocoAdSubErrorType, @Suppress("UNUSED_PARAMETER") assetId: Int?) {
        adShowListener?.onShowError(internalError)
    }
}
