package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.Ad

class PreparedNativeAssets(
    val data: Map<Int, PreparedNativeAsset.Data>,
    val images: Map<Int, PreparedNativeAsset.Image>,
    val titles: Map<Int, PreparedNativeAsset.Title>,
    val videos: Map<Int, PreparedNativeAsset.Video>,
    val failedAssets: List<Pair<NativeOrtbResponse.Asset, String>>
) {
    // TODO. Naming could me much better.
    val allNonFailedAssets by lazy {
        data + images + titles + videos
    }
}

// Prepared asset via precaching or other means in order to be prepared for rendering.
// TODO. Generics for originAsset.
sealed class PreparedNativeAsset(val originAsset: NativeOrtbResponse.Asset) {

    val id: Int = originAsset.id
    val required: Boolean = originAsset.required
    val link: NativeOrtbResponse.Link? = originAsset.link

    class Title(
        originAsset: NativeOrtbResponse.Asset.Title
    ) : PreparedNativeAsset(originAsset) {

        val text: String = originAsset.text
    }

    class Image(
        originAsset: NativeOrtbResponse.Asset.Image,
        val precachedAssetUri: String
    ) : PreparedNativeAsset(originAsset)

    class Video(
        originAsset: NativeOrtbResponse.Asset.Video,
        val vastAd: Ad
    ) : PreparedNativeAsset(originAsset)

    class Data(
        originAsset: NativeOrtbResponse.Asset.Data
    ) : PreparedNativeAsset(originAsset) {

        val value = originAsset.value
    }
}
