package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui

import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService.UserInteraction.Button
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService.UserInteraction.Button.ButtonType

/**
 * Button recorder that can track rendering / unrendering of buttons
 */
interface ButtonRecorder {
    /**
     * Records whether the button was rendered in UI
     */
    fun onButtonRendered(button: Button)

    /**
     * Records whether the button was unrendered in UI
     */
    fun onButtonUnRendered(buttonType: ButtonType)
}

/**
 * Button tracker that tracks states of buttons
 */
interface ButtonTracker : ButtonRecorder {
    /**
     * Tracks the rendered buttons that have been recorded
     */
    fun renderedButtons(): List<Button>
}

internal fun ButtonTracker(): ButtonTracker = ButtonTrackerImpl()

private class ButtonTrackerImpl : ButtonTracker {
    private val buttonLayoutMap = mutableMapOf<ButtonType, Button>()

    override fun onButtonRendered(button: Button) {
        buttonLayoutMap[button.buttonType] = button
    }

    override fun onButtonUnRendered(buttonType: ButtonType) {
        buttonLayoutMap.remove(buttonType)
    }

    override fun renderedButtons(): List<Button> {
        return buttonLayoutMap.toList().map { it.second }
    }
}
