package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render

/**
 * Utility class mainly designated for Compose usage: Primitive type value object wrapper.
 *
 * Main use is to override Compose framework's behaviour not recomposing composable function when arguments do not change/equals() == true;
 *
 * Can be useful for timer restarts, event based controls etc; when it's hard to provide/implement a unique compose ui state for some reason.
 */
class ValueWrapper<T>(val value: T)

sealed class PlaybackProgress {
    object NotAvailable : PlaybackProgress()

    data class Position(val currentPositionMillis: Long, val totalDurationMillis: Long) :
        PlaybackProgress()

    class Finished(val totalDurationMillis: Long) : PlaybackProgress()
}

// TODO. Refactor. Rename. Simplified version of VastResource. Basica
sealed class PreparedVastResource {
    data class Image(val imageUrl: String, val w: Int, val h: Int) : PreparedVastResource()
    data class Html(val webViewId: Int) : PreparedVastResource()
}
