package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render

import android.annotation.SuppressLint
import android.content.Context
import android.graphics.Color
import android.webkit.WebView
import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.BaseWebView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.applyCSSRenderingFix
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.loadDataWithDefaultBaseUrl
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model.VastResource

// TODO. Replace with StaticWebView.
@SuppressLint("SetJavaScriptEnabled")
fun VastWebView(context: Context) = BaseWebView(context).apply {
    scrollBarStyle = WebView.SCROLLBARS_INSIDE_OVERLAY
    isHorizontalScrollBarEnabled = false
    isVerticalScrollBarEnabled = false

    with(settings) {
        setSupportZoom(false)
        javaScriptEnabled = true
        domStorageEnabled = true
        allowFileAccess = false
        allowContentAccess = false
    }

    setBackgroundColor(Color.TRANSPARENT)
}

// TODO. IMPORTANT.
fun BaseWebView.loadVastResource(vastResource: VastResource, widthPx: Int, heightPx: Int) {
    when (vastResource) {
        is VastResource.Static -> {
            when (vastResource.resource.creativeType) {
                com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model.CreativeType.Image ->
                    "<html>" +
                        "<head></head><body style=\"margin:0;padding:0\"><img src=\"${vastResource.resource.resource}\"" +
                        " width=\"100%\" style=\"max-width:100%;max-height:100%;\" />" +
                        "</body></html>"
                com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model.CreativeType.JS -> "<script src=\"${vastResource.resource.resource}\"></script>"
            }
        }
        is VastResource.Html -> {
            vastResource.resource.resource
        }
        is VastResource.IFrame -> {
            "<iframe frameborder=\"0\" scrolling=\"no\" " +
                "marginheight=\"0\" marginwidth=\"0\" style=\"border: 0px; margin: 0px;\"" +
                " width=\"$widthPx\"" +
                " height=\"$heightPx\"" +
                " src=\"${vastResource.resource.resource}\"></iframe>"
        }
    }.let {
        try {
            loadDataWithDefaultBaseUrl(applyCSSRenderingFix(it))
        } catch (e: Exception) {
            MolocoLogger.error("BaseWebView", e.toString(), e)
        }
    }
}
