package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.sizeIn
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.moloco.sdk.internal.scheduling.DispatcherProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.PreparedVastResource
import kotlinx.coroutines.withContext

@Composable
fun VastIcon(
    resource: PreparedVastResource,
    onDisplayed: () -> Unit,
    onClick: () -> Unit,
    modifier: Modifier = Modifier
) {
    LaunchedEffect(Unit) {
        withContext(DispatcherProvider().main) {
            onDisplayed()
        }
    }

    val newModifier = modifier
        .sizeIn(maxWidth = IconSize, maxHeight = IconSize)

    when (resource) {
        is PreparedVastResource.Html -> {
            VastResourceHtml(
                modifier = newModifier,
                htmlResource = resource
            )
        }
        is PreparedVastResource.Image -> VastResourceImage(
            modifier = newModifier
                .clickable(onClick = onClick),
            imageResource = resource
        )
    }
}

private val IconSize = 48.dp
