package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.dec

import android.content.Context
import com.moloco.sdk.internal.scheduling.DispatcherProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.DEC
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.Icon
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.VastPrivacyIcon
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.companion.CompanionGoNextAction
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.cancel
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.launch

internal class DECControllerImpl(
    private val dec: DEC,
    icon: Icon?,
    goNextActionDelaySeconds: UInt,
    context: Context,
    customUserEventBuilderService: CustomUserEventBuilderService,
    private val externalLinkHandler: ExternalLinkHandler
) : DECController {

    private val scope = CoroutineScope(DispatcherProvider().main)

    private val goNextActionHolder = CompanionGoNextAction(
        goNextActionDelaySeconds,
        scope
    )

    override val goNextAction by goNextActionHolder::goNextAction

    override fun reset() = goNextActionHolder.reset()

    private val tracker = DECVastTracker(
        customUserEventBuilderService,
        clickTracking = listOfNotNull(dec.ctaTrackingUrl),
        impressionTracking = listOfNotNull(dec.impressionTrackingUrl),
        skipToDECTracking = listOfNotNull(dec.skipToDECTrackingUrl)
    )

    private val _event = MutableSharedFlow<DECControllerEvent>()
    override val event: Flow<DECControllerEvent> = _event

    override val hasClickThrough = dec.ctaUrl != null

    override val appIconUri = dec.appIconUri
    override val appName = dec.appName
    override val ctaText = dec.ctaText

    private fun onEvent(event: DECControllerEvent) = scope.launch { _event.emit(event) }

    override fun onDisplayStarted() {
        tracker.trackImpression()
        onEvent(DECControllerEvent.DisplayStarted)
    }

    override fun trackSkipToDEC() {
        tracker.trackSkipToDEC()
    }

    override fun onClickThrough(position: CustomUserEventBuilderService.UserInteraction.Position) {
        dec.ctaUrl?.let {
            tracker.trackClick(position)
            externalLinkHandler(it)
            onEvent(DECControllerEvent.ClickThrough)
        }
    }

    private val vastPrivacyIconImpl = VastPrivacyIcon(
        icon?.resource,
        icon?.widthPx,
        icon?.heightPx,
        icon?.clickThroughUrl,
        scope,
        context,
        customUserEventBuilderService,
        externalLinkHandler,
        trackClick = null,
        trackDisplay = null
    )

    override val vastPrivacyIcon by vastPrivacyIconImpl::vastPrivacyIcon

    override fun onVastPrivacyIconClick() = vastPrivacyIconImpl.onVastPrivacyIconClick()

    override fun onVastPrivacyIconDisplayed() = vastPrivacyIconImpl.onVastPrivacyIconDisplayed()

    override fun onButtonRendered(button: CustomUserEventBuilderService.UserInteraction.Button) {
        tracker.trackButtonRender(button)
    }

    override fun onButtonUnRendered(
        buttonType: CustomUserEventBuilderService.UserInteraction.Button.ButtonType
    ) {
        tracker.trackButtonUnRender(buttonType)
    }

    override fun destroy() {
        scope.cancel()
        vastPrivacyIconImpl.destroy()
    }
}
