package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview

import android.view.View
import android.view.ViewGroup
import android.webkit.WebView
import android.widget.FrameLayout
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.ui.Modifier
import androidx.compose.ui.viewinterop.AndroidView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Watermark

@Composable
internal fun AdWebView(webView: WebView, modifier: Modifier = Modifier, watermark: Watermark?) {

    AndroidView(
        modifier = modifier,
        factory = {
            FrameLayout(it).also { fl ->
                with(webView) {
                    setBackgroundColor(android.graphics.Color.TRANSPARENT)
                    visibility = View.VISIBLE
                }

                // Long story short, adding WebView as a children of a container wrapper (FrameLayout)
                // helps for WebView's window.innerHeight not being zero during html content layout passes,
                // therefore avoiding bugs on js creative side.
                // Case in point:
                // King dungeon MRAID game; once MRAID visibility is set to true,
                // js WEBGL framebuffer code breaks due to
                // window.innerHeight == 0 transient layout pass values.
                fl.addView(
                    webView,
                    ViewGroup.LayoutParams(
                        ViewGroup.LayoutParams.MATCH_PARENT,
                        ViewGroup.LayoutParams.MATCH_PARENT
                    )
                )
            }
        },
    ).let { view -> watermark?.ApplyWatermark { view } ?: view }

    // Force remove webView ASAP to avoid
    // "java.lang.IllegalStateException: The specified child already has a parent." exceptions.
    DisposableEffect(webView) {
        onDispose {
            (webView.parent as? ViewGroup)?.removeView(webView)
        }
    }
}
