package com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport

import android.util.Patterns
import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.scheduling.DispatcherProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.core.requestTimeoutMillis
import io.ktor.client.HttpClient
import io.ktor.client.request.get
import io.ktor.http.HttpStatusCode
import kotlinx.coroutines.withContext

private const val TAG = "HttpRequestClient"
internal const val TIMEOUT_MILLIS = 5000L
internal const val WORKER_MAXIMUM_ATTEMPT = 5

interface HttpRequestClient {
    fun send(url: String)
}

internal fun String.isValidUrl(): Boolean {
    return Patterns.WEB_URL.matcher(this).matches().also {
        if (!it) {
            MolocoLogger.error(TAG, "URL is invalid. $this")
        }
    }
}

internal suspend fun HttpClient.sendGetRequest(url: String) = try {
    withContext(DispatcherProvider().io) {
        val status = get(url) {
            requestTimeoutMillis(TIMEOUT_MILLIS)
        }.status

        status == HttpStatusCode.OK || status == HttpStatusCode.NoContent
    }
} catch (e: Exception) {
    false
}
