package com.moloco.sdk.internal.publisher.nativead.ui

import android.annotation.SuppressLint
import android.content.Context
import android.net.Uri
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.RelativeLayout
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.ComposeView
import androidx.compose.ui.unit.dp
import androidx.compose.ui.viewinterop.AndroidView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Watermark
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.defaultNativeAdImageBadge

@SuppressLint("AppCompatCustomView", "ViewConstructor")
internal class NativeAdImageContainer(
    context: Context,
    imageUri: Uri,
    watermark: Watermark,
    onClick: (() -> Unit)?
) : RelativeLayout(context) {
    init {
        val composeImageView = ComposeView(context).apply {
            setContent {
                watermark.ApplyWatermark {
                    Box(modifier = Modifier.fillMaxSize()) {
                        val imageView = ImageView(context).apply {
                            setImageURI(imageUri)
                            layoutParams = LayoutParams(
                                ViewGroup.LayoutParams.MATCH_PARENT,
                                ViewGroup.LayoutParams.MATCH_PARENT
                            )
                            setOnClickListener { onClick?.invoke() }
                        }
                        AndroidView(
                            factory = { imageView },
                            modifier = Modifier.fillMaxSize()
                        )

                        defaultNativeAdImageBadge(
                            modifier = Modifier
                                .align(Alignment.BottomStart)
                                .padding(8.dp)
                        )
                    }
                }
            }
        }
        addView(composeImageView)
    }
}
