package com.moloco.sdk.internal.services.bidtoken.providers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.services.AdData
import com.moloco.sdk.internal.services.AdDataService

/**
 * This class provides the advertising signal needed to construct bid token
 */
internal class AdvertisingSignalProvider(private val advertisingService: AdDataService) : ClientBidTokenSignalProvider<AdData> {
    private var cachedAdData = getAdvertisingSignal()

    override fun needsRefresh(): Boolean {
        val currentSignal = getAdvertisingSignal()
        val needsRefresh = cachedAdData != currentSignal
        MolocoLogger.debugBuildLog(TAG, "[CBT][ASP]: needsRefresh: $needsRefresh")
        return needsRefresh
    }

    override fun tryUpdateSignalState() {
        cachedAdData = getAdvertisingSignal()
    }

    override fun provideSignal(): AdData = getAdvertisingSignal()

    override fun logTag(): String = TAG

    private fun getAdvertisingSignal(): AdData =
        advertisingService.advertisingData().apply {
            MolocoLogger.debugBuildLog(TAG, "[CBT][ASP]: adData: $this")
        }

    companion object {
        private const val TAG = "AdvertisingSignalProvider"
    }
}