package com.moloco.sdk.internal.services.proto

import android.util.Base64
import com.moloco.sdk.UserIntent

/**
 * A Protobuf <-> String encoder service that encodes input Protobuf as String
 */
interface ProtoEncoderService {
    // Bitwise OR URL_SAFE | NO_WRAP flags to perform URL-safe encoding and that exclude line breaks from the output
    fun encodeUserAdInteractionExt(
        input: UserIntent.UserAdInteractionExt,
        flags: Int = Base64.URL_SAFE or Base64.NO_WRAP
    ): String
}

class ProtoEncoderServiceImpl : ProtoEncoderService {
    override fun encodeUserAdInteractionExt(
        input: UserIntent.UserAdInteractionExt,
        flags: Int
    ): String = Base64.encodeToString(input.toByteArray(), flags)
}
