package com.moloco.sdk.publisher

/**
 * Ad display event callback interface
 */
interface AdShowListener {

    /**
     * Called when an ad starts displaying. Impression can be recorded.
     *
     * @param molocoAd The [MolocoAd] instance that provides information about the ad
     */
    fun onAdShowSuccess(molocoAd: MolocoAd)

    /**
     * Called when an error occurs during ad display.
     *
     * @param molocoAdError The [MolocoAdError] instance that provides information about the error
     */
    fun onAdShowFailed(molocoAdError: MolocoAdError)

    /**
     * Called when an ad is hidden.
     *
     * @param molocoAd The [MolocoAd] instance that provides information about the ad
     */
    fun onAdHidden(molocoAd: MolocoAd)

    /**
     * Called when an ad is clicked.
     *
     * @param molocoAd The [MolocoAd] instance that provides information about the ad
     */
    fun onAdClicked(molocoAd: MolocoAd)
}

/**
 * Callback interface for [Banner] ad display events
 *
 * Note: The [AdShowListener.onAdShowSuccess] and [AdShowListener.onAdHidden] callbacks may be called multiple times depending on the banner's visibility state.
 */
interface BannerAdShowListener : AdShowListener

/**
 * Callback interface for [InterstitialAd] display events
 */
interface InterstitialAdShowListener : AdShowListener

/**
 * Callback interface for [RewardedInterstitialAd] display events
 */
interface RewardedInterstitialAdShowListener : InterstitialAdShowListener {

    /**
     * Called when a user is rewarded.
     *
     * @param molocoAd The [MolocoAd] instance that provides information about the ad
     */
    fun onUserRewarded(molocoAd: MolocoAd)

    /**
     * Called when a rewarded video starts.
     *
     * @param molocoAd The [MolocoAd] instance that provides information about the ad
     */
    fun onRewardedVideoStarted(molocoAd: MolocoAd)

    /**
     * Called when a rewarded video is completed.
     *
     * @param molocoAd The [MolocoAd] instance that provides information about the ad
     */
    fun onRewardedVideoCompleted(molocoAd: MolocoAd)
}
