package com.moloco.sdk.publisher

import android.app.Activity
import android.os.Bundle
import android.os.PersistableBundle
import com.moloco.sdk.publisher.MolocoAdError.AdCreateError

private class RewardedInterstitialAdSample : Activity() {

    private lateinit var rewardedInterstitialAd: RewardedInterstitialAd

    override fun onCreate(savedInstanceState: Bundle?, persistentState: PersistableBundle?) {
        super.onCreate(savedInstanceState, persistentState)

        // Once Moloco SDK is initialized, let's create a rewarded interstitial.
        Moloco.createRewardedInterstitial(
            adUnitId = "MOLOCO_ADUNIT_ID",
            null
        ) {rewardedInterstitialAd: RewardedInterstitialAd?, adCreateError: AdCreateError? ->
            if (rewardedInterstitialAd == null) {
                // Weren't able to create rewarded interstitial due to Moloco SDK not initialized or invalid ad unit id.
                finish()
                return@createRewardedInterstitial
            }

            this.rewardedInterstitialAd = rewardedInterstitialAd

            // Fetch a bid response...

            // Load a successful bid response into rewarded interstitial object.
            // You can choose to listen to ad load events as well.
            rewardedInterstitialAd.load(
                bidResponseJson = "bid response",
                listener = object : AdLoad.Listener {
                    override fun onAdLoadSuccess(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }

                    override fun onAdLoadFailed(molocoAdError: MolocoAdError) {
                        TODO("Not yet implemented")
                    }
                }
            )

            // rewarded interstitial load status can also be checked by calling
            rewardedInterstitialAd.isLoaded

            // Show ad when needed. You can also provide an optional ad show listener.
            rewardedInterstitialAd.show(
                listener = object : RewardedInterstitialAdShowListener {

                    override fun onUserRewarded(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }

                    override fun onRewardedVideoStarted(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }

                    override fun onRewardedVideoCompleted(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }

                    override fun onAdShowSuccess(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }

                    override fun onAdShowFailed(molocoAdError: MolocoAdError) {
                        TODO("Not yet implemented")
                    }

                    override fun onAdHidden(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }

                    override fun onAdClicked(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }
                }
            )

            // In order to load an another rewarded interstitial, call load() method again with a new bid response.
            // load() call will force finish and hide the currently displaying ad.
            // For preloading another instance of ad in parallel, consider creating an another RewardedInterstitialAd instance.
            rewardedInterstitialAd.load(
                bidResponseJson = "an_another_bid_response",
                listener = null
            )
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        // Release resources when rewarded interstitial is not needed anymore and/or to prevent memory leaks;
        rewardedInterstitialAd.destroy()
    }
}
