package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer

import kotlinx.coroutines.flow.StateFlow

/**
 * Tells all layers of the Ad from creation whether the ad is displaying
 * This will communicate to publisher level callbacks that the ad is currently displayed
 */
interface AdDisplayState {
    /**
     * Boolean Stateflow describing at what stage of display an ad is being rendered.
     */
    val isAdDisplaying: StateFlow<Boolean>
}
