package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

import android.content.Intent

internal fun Intent.putStartMuted(startMuted: Boolean) {
    putExtra(START_MUTED, startMuted)
}

internal val Intent.startMuted: Boolean
    get() = getBooleanExtra(START_MUTED, true)

private const val START_MUTED = "START_MUTED"

internal fun Intent.putCloseDelaySeconds(value: Int) {
    putExtra(CLOSE_DELAY_SECONDS, value)
}

internal val Intent.closeDelaySeconds: Int
    get() = getIntExtra(CLOSE_DELAY_SECONDS, 0)

private const val CLOSE_DELAY_SECONDS = "CLOSE_DELAY_SECONDS"

internal fun Intent.putDECDelaySeconds(value: Int) {
    putExtra(DEC_DELAY_SECONDS, value)
}

internal val Intent.decDelaySeconds: Int
    get() = getIntExtra(DEC_DELAY_SECONDS, 0)

private const val DEC_DELAY_SECONDS = "DEC_DELAY_SECONDS"

internal fun Intent.putOverrideSkipEnabledDelaySeconds(value: Int) {
    putExtra(SKIP_DELAY_SECONDS, value)
}

internal val Intent.overrideSkipEnabledDelaySeconds: Int
    get() = getIntExtra(SKIP_DELAY_SECONDS, 0)

private const val SKIP_DELAY_SECONDS = "SKIP_DELAY_SECONDS"

internal fun Intent.putOverrideSkipEnabled(value: Boolean?) {
    value?.let { putExtra(SKIP_ENABLED, value) }
}

internal val Intent.overrideSkipEnabled: Boolean?
    get() = if (hasExtra(SKIP_ENABLED)) {
        getBooleanExtra(SKIP_ENABLED, false)
    } else {
        null
    }

private const val SKIP_ENABLED = "SKIP_ENABLED"

// region AutoStore

internal val Intent.autoStoreOnSkip: Boolean
    get() = getBooleanExtra(AUTO_STORE_ON_SKIP, false)

internal fun Intent.putAutoStoreOnSkip(value: Boolean) {
    putExtra(AUTO_STORE_ON_SKIP, value)
}

private const val AUTO_STORE_ON_SKIP = "AUTO_STORE_ON_SKIP"

internal val Intent.autoStoreOnComplete: Boolean
    get() = getBooleanExtra(AUTO_STORE_ON_COMPLETE, false)

internal fun Intent.putAutoStoreOnComplete(value: Boolean) {
    putExtra(AUTO_STORE_ON_COMPLETE, value)
}

private const val AUTO_STORE_ON_COMPLETE = "AUTO_STORE_ON_COMPLETE"

// endregion
