package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

import android.annotation.SuppressLint
import android.content.Context
import androidx.compose.ui.unit.dp
import com.moloco.sdk.service_locator.SdkObjectFactory
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.*
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.toMraidBannerError
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidBridge
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidInline
import kotlinx.coroutines.flow.MutableStateFlow

/**
 * @param options mostly for changing renderer behaviour, like button customization, when to show close button, mute etc. Same as for [FullscreenAd.show]
 */
internal fun MraidBanner(
    context: Context,
    adm: String,
    options: AdWebViewOptions,
    externalLinkHandler: ExternalLinkHandler,
    watermark: Watermark
): Banner<AdShowListener> = MraidBannerImpl(
    context,
    adm,
    options,
    externalLinkHandler,
    watermark = watermark
)

@SuppressLint("ViewConstructor")
private class MraidBannerImpl(
    private val context: Context,
    adm: String,
    private val options: AdWebViewOptions,
    externalLinkHandler: ExternalLinkHandler,
    private val watermark: Watermark
) : Banner<AdShowListener>(context) {
    init {
        tag = "MolocoMraidBannerView"
    }

    override val creativeType: CreativeType = CreativeType.MRAID

    /**
     * Indicates the padding at which the Ad Badge should be rendered in the bottom left corner (the i icon)
     */
    private val AD_BADGE_PADDING = 5.dp

    private val mraidInline = MraidInline(
        context,
        adm,
        onNeedToDetachAdViewBeforeExpand = this::detachMraidViewFromAdViewWrapper,
        onExpandAdViewClosed = this::attachMraidViewToAdViewWrapper,
        onClick = { adShowListener?.onClick() },
        onError = { adShowListener?.onShowError(it.toMraidBannerError()) },
        // TODO. https://youtrack.xenoss.io/issue/XFSDK-35
        // leave it blocked for now.
        forceBlockExpand = true,
        externalLinkHandler,
        mraidBridge = MraidBridge(context, scope)
    )

    override fun destroy() {
        super.destroy()
        mraidInline.destroy()
    }

    // As ugly as it gets.
    private fun detachMraidViewFromAdViewWrapper() {
        adView = null
    }

    // As ugly as it gets.
    private fun attachMraidViewToAdViewWrapper() {
        prepareAdViewForDisplay()
    }

    // Mraid banner can receive a null bid here because the adm is passed to MraidInline : MraidBaseAd
    // which loads the adm in the webview
    override val adLoader = MraidAdLoad(scope, bid = null, SdkObjectFactory.AdLoadModule.decLoader, mraidInline::loadAndReadyMraid)

    override fun prepareAdViewForDisplay() {
        adView = options.AdWebViewRenderer(
            context,
            mraidInline.webView,
            options.closeDelaySeconds,
            MutableStateFlow(false),
            { /* no op */ },
            { /* no-op  */ },
            watermark,
            AD_BADGE_PADDING,
            false
        )
    }
}
