package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.staticrenderer

import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.android_context.ApplicationContext
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.AdWebViewOptions
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Watermark
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.closeDelaySeconds
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.putCloseDelaySeconds
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview.AdWebViewRenderer
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview.StaticAdWebViewScreen
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService.UserInteraction.Button
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.first

internal class StaticAdActivity : ComponentActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        ApplicationContext(applicationContext)

        currentActivity = this

        val staticRenderer = staticRenderer

        val webView = staticWebView
        if (webView == null) {
            MolocoLogger.info("StaticAdActivity", "can't display ad: WebView is missing")
            dismiss()
        } else if (staticRenderer == null) {
            MolocoLogger.info("StaticAdActivity", "can't display ad: StaticRenderer is missing")
            dismiss()
        } else {
            setContent {
                StaticAdWebViewScreen(
                    webView,
                    intent.closeDelaySeconds,
                    Companion::onButtonRendered,
                    Companion::dismiss,
                    staticRenderer,
                    watermark = watermark,
                )
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        onAdClose?.invoke()
        currentActivity = null
    }

    companion object {

        private var staticRenderer: AdWebViewRenderer? = null

        private var staticWebView: StaticWebView? = null

        private var currentActivity: StaticAdActivity? = null

        private var onAdClose: (() -> Unit)? = null

        private val dismiss = MutableStateFlow(false)

        private var watermark: Watermark? = null

        private fun dismiss() {
            dismiss.value = true
        }

        private fun onButtonRendered(button: Button) {
            staticWebView?.onButtonRendered(button)
        }

        // Doesn't support parallel calls, not required though.
        suspend fun show(
            context: Context,
            staticWebView: StaticWebView,
            onAdClose: () -> Unit,
            options: AdWebViewOptions,
            watermark: Watermark
        ) {
            try {
                this.watermark = watermark
                Companion.staticWebView = staticWebView
                staticRenderer = options.AdWebViewRenderer
                Companion.onAdClose = onAdClose
                context.startActivity(
                    Intent(context, StaticAdActivity::class.java).apply {
                        putCloseDelaySeconds(options.closeDelaySeconds)
                        flags = Intent.FLAG_ACTIVITY_NEW_TASK
                    }
                )

                dismiss.first { it }
            } finally {
                dismiss.value = false
                Companion.onAdClose = null
                Companion.staticWebView = null
                staticRenderer = null

                currentActivity?.finish()
            }
        }
    }
}
